'use strict';

function ChatCtrl($scope){
    $scope.message = '';
    $scope.history = [];
    $scope.messages = [];
    $scope.users = [];

    if(chatHost != '')
    {
        $scope.$on('Chat:open', function(){
            $scope.show();
        });

        var socket = io.connect(chatHost);
        socket.on('newMessage', function(data){
            $scope.messages.push(data);

            if($scope.isMinimized())
            {
                if(!$scope.isBlinked())
                {
                    $scope.setBlink();
                }
            }
            $scope.$apply();
            angular.element('#chat-panel .nano').nanoScroller();
            angular.element('#chat-panel .nano').nanoScroller({ scroll: 'bottom' });
        });

        socket.on('usersList', function(data){
            $scope.users = data;
            $scope.$apply();
        });

        socket.on('historyList', function(data){
            $scope.history = data;
            $scope.$apply();
        });

        socket.emit('connect', {
            room: chatG,
            user: chatU
        });
    }

    $scope.sendMsg = function(){
        var msg = $scope.message.replace(/<(?:.|\n)*?>/gm, '');
        if(msg != '')
        {
            socket.emit('sendMsg', {
                message: msg
            });
            $scope.message = '';
        }
    }

    $scope.minimize = function(event){
        event.stopPropagation();
        var element = angular.element('#chat-panel');
        if(element.hasClass('mini'))
        {
            $scope.show();
        }
        else
        {
            element.addClass('mini');
        }
    }

    $scope.hide = function(event){
        event.stopPropagation();
        var element = angular.element('#chat-panel');
        if(!element.hasClass('hidden'))
        {
            element.addClass('hidden');
        }
    }

    $scope.show = function(){
        var element = angular.element('#chat-panel');
        if(element.hasClass('hidden'))
        {
            element.removeClass('hidden');
        }
        if(element.hasClass('mini'))
        {
            element.removeClass('mini');
        }
        if(element.hasClass('blink'))
        {
            element.removeClass('blink');
        }

        angular.element('#chat-panel .nano').nanoScroller();
        angular.element('#chat-panel .nano').nanoScroller({ scroll: 'bottom' });
    }


    $scope.isMinimized = function(){
        return angular.element('#chat-panel').hasClass('mini');
    }
    $scope.isBlinked = function(){
        return angular.element('#chat-panel').hasClass('blink');
    }
    $scope.setBlink = function(){
        angular.element('#chat-panel').addClass('blink');
    }

    $scope.isMe = function(user){
        return user.id == chatU.id;
    }
}

ChatCtrl.$inject = ['$scope'];